﻿<?LassoScript
/*
An experimental demo illustrating how to convert a Lasso Wiki formatted text into 
a pdf while keeping the formatting.

Author: Jolle Carlestam
Prepared for the Lasso Developer Conference in Chicago 2008
Use and alter freely but please keep a reference to where you found it
*/

// lp_string_linefeedset is used to normalize line endings
!lasso_tagexists('lp_string_linefeedset') ? include('lp_string_linefeedSet.inc');

// Setting vars that's used repeatedly later
var('wclass' = string,
'ordlistactive' = false,
'uordlistactive' = false,
'paragraph' = string,
'lines' = null,
'temp' = null);

// Adding some demo content to fill the pdf with. It's tagged using Lasso Wiki
var('content' = '[1]To go from Wiki to PDF[/1]

A [b]\'LassoWiki\'[/b] text is a text that\'s been tagged using the [b]Lasso Wiki markup language[/b] originally designed for the [[http://www.lassotech.com/]] Web site.

[2]The vision
Wouldn\'t it be wonderful if the same markup could be used to automatically produce pdf documents with [em]all the Wiki markup translated into font styles[/em] usable by the Lasso PDF tag suite?
[2]Features
The Wiki to PDF translation for the moment support the following markup tags:
[*]Heading 1 - 4
[*]Bold and italic styling
[*]Lists

And here\'s a numbered list to prove the point:
[#] Number 1
[#] Number 2
Note that the "point" is not completely proven yet. I\'m still struggling with the wrong font being used for the number. (It could be a bug...)

[4]Adding a second list to check that it\'s working.
[#] Number 01
[#] Number 02
[#] Number 03

[2]A finishing disclaimer
This is work in progress and still lacks a lot of necessary features. A number of Lasso Wiki tags are not supported. Better to see this as an inspiration to your own [b]superior[/b] solution.

');
$content = lp_string_linefeedSet($content,'\r');



// Setting some vars holding basic data.
var('pagetype' = 'A4',
	'pageheight' = 842, // points
	'pagewidth' = 595);

// If you prefer US-Letter sized paper uncomment this section
/*
var('pagetype' = 'LETTER',
	'pageheight' = 792, // points
	'pagewidth' = 612);

*/

// Create the pdf_doc object
var( 'pdf' = pdf_doc( -size = $pagetype,
	-margins = array( 72.0, 50.0, 72.0, 25.0), -nocompress));

// Setting font variables for the different styles handled by LassoWiki
var('header1' = pdf_font(
	-face = 'Helvetica-Bold',
	-size = 20));

var('header2' = pdf_font(
	-face = 'Helvetica-Bold',
	-size = 16));

var('header3' = pdf_font(
	-face = 'Helvetica-Bold',
	-size = 12));

var('header4' = pdf_font(
	-face = 'Helvetica-Bold',
	-size = 10));

var('plain' = pdf_font(
	-face = 'Times-Roman',
	-size = 10));

var('bold' = pdf_font(
	-face = 'Times-Bold',
	-size = 10));

var('italic' = pdf_font(
	-face = 'Times-Italic',
	-size = 10));


// Setting an empty PDF_Text object to use as a holder of the coming content
var('pdftext' = pdf_text( '',
		-type = 'paragraph',
		-leading = 12));

// Splitting by line feeds so that we can work on each paragraph separately
iterate($content -> split('\r'), $paragraph);

	// Replacing all end tags like [/b] with line feeds since they're not needed anymore
	$paragraph = string_replaceregexp($paragraph,
		-find = '\\[/.*?\\]',
		-replace = '\r',
		-ignorecase);

	// The regExp used here creates an array with markup tags alternating with content
	$lines = regexp(-input = $paragraph, -find = '(\\[[h1-4#*bem \t]+\\])[ \t]*(.*?)(?=\r|$)', -ignorecase) -> split;

	iterate($lines, $temp);

		// We no longer need line feeds since we've split on each line
		$temp -> replace('\r', '');

		// If $temp starts with a "[" it's a markup tag. Let's put it in
		// the wclass var to use it on the next iteration.
		if($temp -> beginswith('['));
			$wclass = $temp;

		// If $wclass contains a markup tag, in this case a [b] then the
		// content in $temp should be added to the PDF_Text holder using
		// the appropriate font, like the bold font.
		else($wclass == '[b]');
			$pdftext -> add(pdf_text( $temp,
				-type = 'chunk',
				-font = $bold));
			$wclass = string; // Resetting so that next iteration can start fresh

		// Adding the content of $temp using the italic font
		else($wclass == '[em]');
			$pdftext -> add(pdf_text( $temp,
				-type = 'chunk',
				-font = $italic));
			$wclass = string;

		// This content is a header. So we add it using type "paragraph".
		// That adds the content on a new row and lets us use a leading param.
		else($wclass == '[1]' || $wclass == '[h1]' );
			$pdftext -> add(pdf_text($temp,
				-type = 'paragraph',
				-font = $header1,
				-leading = 28));

			// Once the heading is added we need to reset the PDF_Text
			// holder and prepare it for regular content coming
			// in following iterations.
			$pdftext -> add(pdf_text( '',
				-type = 'paragraph',
				-font = $plain,
				-leading = 12));
			$wclass = string;

		// Another Heading
		else($wclass == '[2]' || $wclass == '[h2]' );
			$pdftext -> add(pdf_text($temp,
				-type = 'paragraph',
				-font = $header2,
				-leading = 24));
			$pdftext -> add(pdf_text( '',
				-type = 'paragraph',
				-font = $plain,
				-leading = 12));
			$wclass = string;

		// Yet another heading
		else($wclass == '[3]' || $wclass == '[h3]' );
			$pdftext -> add(pdf_text($temp,
				-type = 'paragraph',
				-font = $header3,
				-leading = 18));
			$pdftext -> add(pdf_text( '',
				-type = 'paragraph',
				-font = $plain,
				-leading = 12));
			$wclass = string;

		// The last heading level
		else($wclass == '[4]' || $wclass == '[h4]' );
			$pdftext -> add(pdf_text($temp,
				-type = 'paragraph',
				-font = $header4,
				-leading = 12));
			$pdftext -> add(pdf_text( '',
				-type = 'paragraph',
				-font = $plain,
				-leading = 12));
			$wclass = string;

		// Here's a tricky part. This is to support unordered lists
		else($wclass == '[*]');

			// Check if a list is already created
			if(!$uordlistactive);

				// If this is the first time the list appears we need
				// to add the content saved in $pdftext to the PDF_Doc object.
				// Lists can't be added to a PDF_Text object
				$pdf -> add($pdftext);

				// Create a PDF_List object to hold the list items
				var('uordlist' = pdf_list(-format = 'bullet',
						-font = $plain,
						-leading = 12,
						-indent = 20));

				// Empty the PDF_Text object since we just added it to the PDF_Doc
				$pdftext = pdf_text( '',
					-type = 'paragraph',
					-leading = 12);

				// Set a flag so we know that we've created a list object.
				$uordlistactive = true;
			/if;

			// Time to actually add the list item to the list
			$uordlist -> add($temp);

			$wclass = string; // Resetting so that next iteration can start fresh

		// The same procedure as above but this time for ordered lists
		else($wclass == '[#]');
			if(!$ordlistactive);
				var('ordlist' = pdf_list(-format = 'number', -font = $plain,
					-leading = 12, -indent = 20));

				$pdf -> add($pdftext);

				$pdftext = pdf_text( '',
					-type = 'paragraph',
					-leading = 12);
				$ordlistactive = true;
			/if;

			$ordlist -> add($temp);
			$wclass = string;
		// No markup tag. Time to add the content using the regular font
		else;
			$pdftext -> add(pdf_text( $temp,
				-type = 'chunk',
				-font = $plain));

		/if;

		// If we have an unordered list and that list have no
		// more list items it's time to add it to the PDF_Doc
		if($uordlistactive && $wclass -> size > 0 && $wclass != '[*]');
			$pdf -> add($uordlist);
			$uordlistactive = false;
		/if;

		// And if we have an unordered list we add it here
		if($ordlistactive && $wclass -> size > 0 && $wclass != '[#]');
			$pdf -> add($ordlist);
			$ordlistactive = false;
		/if;

	/iterate;

/iterate;

// Time to add the concatenated PDF_Text object to the PDF_Doc
$pdf -> add($pdftext);

$pdf -> close;
pdf_serve( -content = $pdf, -file = 'demo9.pdf');


?>